/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Data;
using System.Collections.Specialized;
using System.Collections;
using System.Runtime.Serialization;

using Borland.Eco.DataRepresentation;
using Borland.Eco.Persistence;
using Borland.Eco.Persistence.ORMapping;
using Borland.Eco.Persistence.Configuration;
using Borland.Eco.Persistence.Connection;

namespace Borland.Eco.Persistence
{
	public class GuidKeyMapper: GenericKeyMapper, IKeyMapper
	{
		private ISingleColumnAttributemapping m_GuidMapper;
		private string InternalColumnType(int columnNum)
		{
		return m_GuidMapper.ColumnType(columnNum);
		}

		public GuidKeyMapper(): base() {}
		public void IdToParameters(ObjectId id, IDataParameter[] parameters)
		{
			System.Object value;
			if (id != null)
				value = id.Key;
			else
				value = null;
			(KeyMappers[0] as ISingleColumnAttributemapping).ValueToParameter(value, parameters[0]);
		}

		public ObjectId IdFromFields(IField[] keyFields, ArrayList keyMappers, int classId, int timeStamp)
		{
			IField f = keyFields[0];

			if (f.IsNull)
			{
				return null;
			}
			else
			{
				System.Object value = (KeyMappers[0] as ISingleColumnAttributemapping).ColumnToValue(f.Value);
				if (timeStamp != VersionConst.CurrentVersion)
					return new TimestampedDefaultId(value, classId, timeStamp);
				else
					return new DefaultId(value, classId);
			}
		}

		public int ColumnCount()
		{
			return 1;
		}

		public void ReserveId()
		{
			// intentionally left blank;
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="oldId"/> is null</exception>
		public ObjectId NewIdPreUpdate(IDatabase db, ObjectId oldId)
		{
			if (oldId == null) throw new ArgumentNullException("oldId"); // Do not localize
			if (oldId.Key is System.Guid)
				return oldId;
			else
			{
#if CF
				throw new NotSupportedException();
#else
				System.Guid newId = System.Guid.NewGuid();
				return new DefaultId(newId, oldId.ClassId);
#endif
			}
		}

		public ObjectId NewIdFromAttributes(ObjectContents objContents, ArrayList memberIndexes, IdTranslationList translationList)
		{
			return null;
		}

		public void InitializePSDescriptions(DatabaseDefinition db)
		{
			// intentionally left blank
		}

		public void InitializeDatabase(IDatabase db)
		{
			// intentionally left blank
		}

		public void InitializeDatabaseScript(StringCollection script)
		{
			// intentionally left blank
		}

		public IdAllocationMode GetIdAllocationMode()
		{
			return IdAllocationMode.PreUpdate;
		}

		public string ColumnType(ArrayList KeyMappers, int columnNum)
		{
			return InternalColumnType(columnNum);
		}

		public void Initialize(SqlDatabaseConfig config, ArrayList keyMappers)
		{
			InternalInitialize(config, keyMappers);
			m_GuidMapper = MapperDictionary.FindSingleColumnMappingByName(typeof(System.Guid).ToString());
		}

		public string IdListToWhereFragment(ObjectIdCollection idList, IParameterized parameterized, StringCollection idColumns)
		{
			return InternalIdListToWhereFragment(idList, parameterized, idColumns, m_GuidMapper);
		}

		public string IdToWhereFragment(ObjectId id, IParameterized parameterized, StringCollection idColumns)
		{
			ObjectIdCollection list = new ObjectIdCollection();
			list.Add(id);
			return IdListToWhereFragment(list, parameterized, idColumns);
		}
	}
}


